/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal;

import io.purplejs.core.Engine;
import io.purplejs.core.EngineBinder;
import io.purplejs.core.EngineModule;
import io.purplejs.http.Request;
import io.purplejs.http.error.ErrorHandler;
import io.purplejs.http.handler.HttpHandlerFactory;
import io.purplejs.http.internal.RequestAccessor;
import io.purplejs.http.internal.error.DefaultErrorHandler;
import io.purplejs.http.internal.handler.HttpHandlerFactoryImpl;
import io.purplejs.http.internal.websocket.WebSocketRegistry;
import io.purplejs.http.internal.websocket.WebSocketRegistryImpl;
import io.purplejs.http.websocket.WebSocketManager;
import java.util.function.Supplier;

public final class HttpModule
implements EngineModule {
    private HttpHandlerFactoryImpl handlerFactory;

    public void configure(EngineBinder binder) {
        this.handlerFactory = new HttpHandlerFactoryImpl();
        binder.provider(Request.class, (Supplier)new RequestAccessor());
        binder.instance(ErrorHandler.class, (Object)new DefaultErrorHandler());
        binder.instance(HttpHandlerFactory.class, (Object)this.handlerFactory);
        WebSocketRegistryImpl webSocketRegistry = new WebSocketRegistryImpl();
        binder.instance(WebSocketRegistry.class, (Object)webSocketRegistry);
        binder.instance(WebSocketManager.class, (Object)webSocketRegistry);
        binder.initializer(this::initialize);
    }

    private void initialize(Engine engine) {
        this.handlerFactory.init(engine);
    }
}

