/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.net.MediaType;
import io.purplejs.http.Headers;
import io.purplejs.http.Parameters;
import io.purplejs.http.Request;
import io.purplejs.http.RequestImpl;
import io.purplejs.http.multipart.MultipartForm;
import java.net.URI;
import java.util.Map;

public final class RequestBuilder {
    private String method;
    private URI uri;
    private final Parameters parameters = new Parameters();
    private final Headers headers = new Headers();
    private final Map<String, String> cookies = Maps.newHashMap();
    private MediaType contentType;
    private long contentLength = 0L;
    private ByteSource body;
    private boolean webSocket = false;
    private MultipartForm multipart;
    private Object raw;

    private RequestBuilder() {
    }

    public RequestBuilder method(String method) {
        this.method = method.toUpperCase();
        return this;
    }

    public RequestBuilder uri(String uri) {
        return this.uri(URI.create(uri));
    }

    public RequestBuilder uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public RequestBuilder parameter(String name, String value) {
        this.parameters.put(name, value);
        return this;
    }

    public RequestBuilder header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public RequestBuilder cookie(String name, String value) {
        this.cookies.put(name, value);
        return this;
    }

    public RequestBuilder contentType(String contentType) {
        return this.contentType(contentType != null ? MediaType.parse((String)contentType) : null);
    }

    public RequestBuilder contentType(MediaType contentType) {
        this.contentType = contentType;
        return this;
    }

    public RequestBuilder contentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public RequestBuilder body(String body) {
        this.body = body != null ? ByteSource.wrap((byte[])body.getBytes(Charsets.UTF_8)) : null;
        return this;
    }

    public RequestBuilder body(ByteSource body) {
        this.body = body;
        return this;
    }

    public RequestBuilder webSocket(boolean webSocket) {
        this.webSocket = webSocket;
        return this;
    }

    public RequestBuilder multipart(MultipartForm multipart) {
        this.multipart = multipart;
        return this;
    }

    public RequestBuilder raw(Object raw) {
        this.raw = raw;
        return this;
    }

    public Request build() {
        RequestImpl request = new RequestImpl();
        request.method = this.method != null ? this.method : "GET";
        request.uri = this.uri != null ? this.uri : URI.create("http://localhost:8080");
        request.parameters = this.parameters;
        request.headers = this.headers;
        request.cookies = this.cookies;
        request.contentType = this.contentType;
        request.contentLength = this.contentLength;
        request.body = this.body != null ? this.body : ByteSource.empty();
        request.webSocket = this.webSocket;
        request.raw = this.raw;
        request.multipart = this.multipart;
        return request;
    }

    public static RequestBuilder newBuilder() {
        return new RequestBuilder();
    }
}

