/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.websocket;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.purplejs.http.internal.websocket.WebSocketRegistry;
import io.purplejs.http.websocket.WebSocketSession;
import java.util.Map;
import java.util.stream.Stream;

public final class WebSocketRegistryImpl
implements WebSocketRegistry {
    private final Map<String, WebSocketSession> idToSession = Maps.newConcurrentMap();
    private final Multimap<String, WebSocketSession> groupToId = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());

    @Override
    public WebSocketSession getSession(String id) {
        return this.idToSession.get(id);
    }

    @Override
    public Stream<WebSocketSession> getByGroup(String group) {
        return this.groupToId.get((Object)group).stream();
    }

    @Override
    public void add(WebSocketSession session) {
        this.idToSession.put(session.getId(), session);
        this.groupToId.put((Object)session.getGroup(), (Object)session);
    }

    @Override
    public void remove(WebSocketSession session) {
        this.idToSession.remove(session.getId());
        this.groupToId.remove((Object)session.getGroup(), (Object)session);
    }
}

