/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.response;

import com.google.common.net.MediaType;
import io.purplejs.core.value.ScriptValue;
import io.purplejs.http.Cookie;
import io.purplejs.http.Response;
import io.purplejs.http.ResponseBuilder;
import io.purplejs.http.Status;
import io.purplejs.http.internal.response.BodySerializer;
import io.purplejs.http.internal.websocket.WebSocketConfigFactory;

public final class ScriptToResponse {
    public Response toResponse(ScriptValue value) {
        ResponseBuilder builder = ResponseBuilder.newBuilder();
        if (value == null) {
            builder.contentType(MediaType.PLAIN_TEXT_UTF_8);
            return builder.build();
        }
        builder.value(value);
        this.populateStatus(builder, value.getMember("status"));
        ScriptValue body = value.getMember("body");
        MediaType type = this.findContentType(value.getMember("contentType"), body);
        this.populateContentType(builder, type);
        this.populateBody(builder, body);
        this.populateHeaders(builder, value.getMember("headers"));
        this.populateCookies(builder, value.getMember("cookies"));
        this.setRedirect(builder, value.getMember("redirect"));
        this.setWebSocket(builder, value.getMember("webSocket"));
        return builder.build();
    }

    private MediaType findContentType(ScriptValue value, ScriptValue body) {
        String type;
        String string = type = value != null ? (String)value.getValue(String.class) : null;
        if (type != null) {
            return MediaType.parse((String)type);
        }
        return new BodySerializer().findType(body);
    }

    private void populateStatus(ResponseBuilder builder, ScriptValue value) {
        Integer status = value != null ? (Integer)value.getValue(Integer.class) : null;
        builder.status(status != null ? Status.from(status) : Status.OK);
    }

    private void populateContentType(ResponseBuilder builder, MediaType type) {
        builder.contentType(type != null ? type : MediaType.PLAIN_TEXT_UTF_8);
    }

    private void populateBody(ResponseBuilder builder, ScriptValue value) {
        builder.body(new BodySerializer().toBody((Object)value));
    }

    private void populateHeaders(ResponseBuilder builder, ScriptValue value) {
        if (value == null) {
            return;
        }
        if (!value.isObject()) {
            return;
        }
        for (String key : value.getKeys()) {
            builder.header(key, (String)value.getMember(key).getValue(String.class));
        }
    }

    private void setRedirect(ResponseBuilder builder, ScriptValue value) {
        String redirect;
        String string = redirect = value != null ? (String)value.getValue(String.class) : null;
        if (redirect == null) {
            return;
        }
        builder.status(Status.SEE_OTHER);
        builder.header("Location", redirect);
    }

    private void populateCookies(ResponseBuilder builder, ScriptValue value) {
        if (value == null) {
            return;
        }
        for (String key : value.getKeys()) {
            this.addCookie(builder, value.getMember(key), key);
        }
    }

    private <T> T getValue(ScriptValue value, Class<T> type, T defValue) {
        if (value == null) {
            return null;
        }
        Object result = value.getValue(type);
        return (T)(result != null ? result : defValue);
    }

    private <T> T getMemberValue(ScriptValue value, String name, Class<T> type, T defValue) {
        T result = this.getValue(value.getMember(name), type, defValue);
        return result != null ? result : defValue;
    }

    private Cookie newCookie(ScriptValue value, String key) {
        Cookie cookie = new Cookie(key);
        if (value.isObject()) {
            cookie.setValue(this.getMemberValue(value, "value", String.class, ""));
            cookie.setPath(this.getMemberValue(value, "path", String.class, null));
            cookie.setDomain(this.getMemberValue(value, "domain", String.class, null));
            cookie.setComment(this.getMemberValue(value, "comment", String.class, null));
            cookie.setMaxAge(this.getMemberValue(value, "maxAge", Integer.class, -1));
            cookie.setSecure(this.getMemberValue(value, "secure", Boolean.class, false));
            cookie.setHttpOnly(this.getMemberValue(value, "httpOnly", Boolean.class, false));
        } else {
            cookie.setValue(this.getValue(value, String.class, ""));
        }
        return cookie;
    }

    private void addCookie(ResponseBuilder builder, ScriptValue value, String key) {
        if (value != null) {
            builder.cookie(this.newCookie(value, key));
        }
    }

    private void setWebSocket(ResponseBuilder builder, ScriptValue value) {
        builder.webSocket(new WebSocketConfigFactory().create(value));
    }
}

