/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.handler;

import io.purplejs.core.value.ScriptExports;
import io.purplejs.core.value.ScriptValue;
import io.purplejs.http.Request;
import io.purplejs.http.Response;
import io.purplejs.http.ResponseBuilder;
import io.purplejs.http.Status;
import io.purplejs.http.internal.RequestAccessor;
import io.purplejs.http.internal.handler.JsonRequest;
import io.purplejs.http.internal.response.ScriptToResponse;
import java.util.function.Function;

final class ServeRequestCommand
implements Function<ScriptExports, Response> {
    private static final String GET_METHOD = "get";
    private static final String HEAD_METHOD = "head";
    private static final String SERVICE_METHOD = "service";
    private final Request request;

    ServeRequestCommand(Request request) {
        this.request = request;
    }

    @Override
    public Response apply(ScriptExports exports) {
        try {
            RequestAccessor.set(this.request);
            Response response = this.doExecute(exports);
            return response;
        }
        finally {
            RequestAccessor.remove();
        }
    }

    private Response doExecute(ScriptExports exports) {
        String method = this.findMethod(exports);
        if (method == null) {
            return this.methodNotAllowed();
        }
        JsonRequest wrapper = new JsonRequest(this.request);
        ScriptValue value = exports.executeMethod(method, new Object[]{wrapper});
        return new ScriptToResponse().toResponse(value);
    }

    private String findMethod(ScriptExports exports) {
        String method = this.request.getMethod().toLowerCase();
        if (exports.hasMethod(method)) {
            return method;
        }
        if (exports.hasMethod(SERVICE_METHOD)) {
            return SERVICE_METHOD;
        }
        if (method.equals(HEAD_METHOD) && exports.hasMethod(GET_METHOD)) {
            return GET_METHOD;
        }
        return null;
    }

    private Response methodNotAllowed() {
        return ResponseBuilder.newBuilder().status(Status.METHOD_NOT_ALLOWED).build();
    }
}

