/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.gradle;

import io.purplejs.gradle.PurpleExtension;
import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.JavaExec;

public class BootPlugin
implements Plugin<Project> {
    private PurpleExtension ext;
    private Project project;

    public void apply(Project project) {
        this.project = project;
        this.ext = (PurpleExtension)this.project.getExtensions().create("purplejs", PurpleExtension.class, new Object[]{this.project});
        this.addPlugins();
        this.addRepositories();
        this.addDependencies();
        this.configureAppPlugin();
    }

    private void addPlugins() {
        this.project.getPlugins().apply(JavaPlugin.class);
        this.project.getPlugins().apply(ApplicationPlugin.class);
    }

    private void addRepositories() {
        this.project.getRepositories().jcenter();
    }

    private void addDependencies() {
        DependencyHandler handler = this.project.getDependencies();
        handler.add("compile", (Object)this.ext.dependency("boot"));
        handler.add("testCompile", (Object)this.ext.dependency("testing"));
    }

    private void configureAppPlugin() {
        ApplicationPluginConvention convention = (ApplicationPluginConvention)this.project.getConvention().findPlugin(ApplicationPluginConvention.class);
        convention.setMainClassName("io.purplejs.boot.MainApp");
        JavaExec runTask = (JavaExec)this.project.getTasks().getByName("run");
        runTask.systemProperty("io.purplejs.runMode", (Object)"dev");
        String devDirs = new File(this.project.getProjectDir(), "src/main/resources").getAbsolutePath();
        runTask.systemProperty("io.purplejs.devSourceDirs", (Object)devDirs);
    }
}

