/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.util;

import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSource;
import io.purplejs.core.exception.ExceptionHelper;
import java.io.InputStream;
import java.util.List;

public final class IOHelper {
    public static CharSource toCharSource(ByteSource source) {
        return source.asCharSource(Charsets.UTF_8);
    }

    public static String readString(CharSource source) {
        return ExceptionHelper.wrap(() -> ((CharSource)source).read());
    }

    public static String readString(ByteSource source) {
        return IOHelper.readString(IOHelper.toCharSource(source));
    }

    public static ByteSource toByteSource(InputStream in) {
        return ExceptionHelper.wrap(() -> ByteSource.wrap((byte[])ByteStreams.toByteArray((InputStream)in)));
    }

    public static List<String> readLines(ByteSource source) {
        return IOHelper.readLines(IOHelper.toCharSource(source));
    }

    public static List<String> readLines(CharSource source) {
        return (List)ExceptionHelper.wrap(() -> ((CharSource)source).readLines());
    }
}

