/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.resource;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;

public final class ResourcePath {
    public static final ResourcePath ROOT = new ResourcePath(new String[0]);
    private static final String SEP = "/";
    private final String path;
    private final String[] elements;

    private ResourcePath(String ... elements) {
        this.elements = elements;
        this.path = SEP + Joiner.on((String)SEP).join((Object[])this.elements);
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.isRoot() ? "" : this.elements[this.elements.length - 1];
    }

    public String getExtension() {
        String name = this.getName();
        return Files.getFileExtension((String)name);
    }

    public String getNameWithoutExtension() {
        String name = this.getName();
        return Files.getNameWithoutExtension((String)name);
    }

    public boolean isRoot() {
        return this.elements.length == 0;
    }

    public ResourcePath getParent() {
        if (this.isRoot()) {
            return null;
        }
        String[] result = new String[this.elements.length - 1];
        System.arraycopy(this.elements, 0, result, 0, result.length);
        return ResourcePath.from(result);
    }

    public ResourcePath resolve(String relPath) {
        if (relPath.startsWith(SEP)) {
            return ResourcePath.from(relPath);
        }
        return ResourcePath.from(this.path + SEP + relPath);
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object o) {
        return o instanceof ResourcePath && this.path.equals(((ResourcePath)o).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private static String normalizePath(String path) {
        return Files.simplifyPath((String)(SEP + path));
    }

    private static String[] split(String path) {
        Iterable it = Splitter.on((String)SEP).omitEmptyStrings().trimResults().split((CharSequence)path);
        return (String[])Iterables.toArray((Iterable)it, String.class);
    }

    private static ResourcePath from(String[] elements) {
        if (elements.length == 0) {
            return ROOT;
        }
        return new ResourcePath(elements);
    }

    public static ResourcePath from(String path) {
        return ResourcePath.from(ResourcePath.split(ResourcePath.normalizePath(path)));
    }
}

