/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.value;

import io.purplejs.core.internal.nashorn.NashornHelper;
import io.purplejs.core.internal.nashorn.NashornRuntime;
import io.purplejs.core.internal.value.ArrayScriptValue;
import io.purplejs.core.internal.value.FunctionScriptValue;
import io.purplejs.core.internal.value.ObjectScriptValue;
import io.purplejs.core.internal.value.ScalarScriptValue;
import io.purplejs.core.internal.value.ScriptValueFactory;
import io.purplejs.core.value.ScriptValue;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public final class ScriptValueFactoryImpl
implements ScriptValueFactory {
    private final NashornRuntime runtime;

    public ScriptValueFactoryImpl(NashornRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public ScriptValue newValue(Object value) {
        if (value == null) {
            return null;
        }
        if (NashornHelper.INSTANCE.isUndefined(value)) {
            return null;
        }
        if (NashornHelper.INSTANCE.isDateType(value)) {
            return new ScalarScriptValue(NashornHelper.INSTANCE.toDate(value));
        }
        if (value instanceof ScriptObjectMirror) {
            return this.newValueFromObjectMirror((ScriptObjectMirror)value);
        }
        return new ScalarScriptValue(value);
    }

    private ScriptValue newValueFromObjectMirror(ScriptObjectMirror value) {
        if (value.isFunction()) {
            return new FunctionScriptValue(this, value, this.runtime);
        }
        if (value.isArray()) {
            return new ArrayScriptValue(this, value);
        }
        return new ObjectScriptValue(this, value);
    }
}

