/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.value;

import io.purplejs.core.resource.ResourcePath;
import io.purplejs.core.value.ScriptExports;
import io.purplejs.core.value.ScriptValue;

public final class ScriptExportsImpl
implements ScriptExports {
    private final ResourcePath resource;
    private final ScriptValue value;

    public ScriptExportsImpl(ResourcePath resource, ScriptValue value) {
        this.resource = resource;
        this.value = value;
    }

    @Override
    public ResourcePath getResource() {
        return this.resource;
    }

    @Override
    public ScriptValue getValue() {
        return this.value;
    }

    @Override
    public boolean hasMethod(String name) {
        return this.getMethod(name) != null;
    }

    @Override
    public ScriptValue executeMethod(String name, Object ... args) {
        ScriptValue method = this.getMethod(name);
        if (method == null) {
            return null;
        }
        return method.call(args);
    }

    private ScriptValue getMethod(String name) {
        ScriptValue func = this.value.getMember(name);
        return func != null && func.isFunction() ? func : null;
    }
}

