/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.value;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.purplejs.core.internal.value.AbstractScriptValue;
import io.purplejs.core.internal.value.ScriptValueFactory;
import io.purplejs.core.value.ScriptValue;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

final class ArrayScriptValue
extends AbstractScriptValue {
    private final ScriptValueFactory factory;
    private final ScriptObjectMirror value;

    ArrayScriptValue(ScriptValueFactory factory, ScriptObjectMirror value) {
        this.factory = factory;
        this.value = value;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public List<ScriptValue> getArray() {
        ArrayList result = Lists.newArrayList();
        for (Object item : this.value.values()) {
            ScriptValue wrapped = this.factory.newValue(item);
            if (wrapped == null) continue;
            result.add(wrapped);
        }
        return result;
    }

    @Override
    public Object toJavaObject() {
        return this.getArray().stream().map(ScriptValue::toJavaObject).collect(Collectors.toList());
    }

    @Override
    public JsonElement toJson() {
        JsonArray json = new JsonArray();
        for (ScriptValue value : this.getArray()) {
            json.add(value.toJson());
        }
        return json;
    }

    @Override
    public Object getRaw() {
        return this.value;
    }
}

