/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.util;

import io.purplejs.core.internal.util.JavaVersion;
import java.util.Properties;

public final class RequirementChecker {
    private static final int JAVA_UPDATE_MIN = 92;
    private final Properties properties;

    RequirementChecker(Properties properties) {
        this.properties = properties;
    }

    void doCheck() {
        this.checkJavaVersion();
    }

    private void checkJavaVersion() {
        JavaVersion version = new JavaVersion(this.properties);
        if (version.isJava9()) {
            return;
        }
        if (!version.isJava8()) {
            throw this.throwJavaVersionRequirements(version);
        }
        if (version.getUpdate() < 92) {
            throw this.throwJavaVersionRequirements(version);
        }
    }

    private RuntimeException throwJavaVersionRequirements(JavaVersion version) {
        return new RuntimeException(String.format("Java 1.8 update %s and above is required. You are running %s.", 92, version));
    }

    public static void check() {
        new RequirementChecker(System.getProperties()).doCheck();
    }
}

