/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.util;

import java.util.Properties;

final class JavaVersion {
    private final String value;

    JavaVersion(Properties props) {
        this.value = props.getProperty("java.version");
    }

    boolean isJava8() {
        return this.value.startsWith("1.8");
    }

    boolean isJava9() {
        return this.value.startsWith("1.9");
    }

    int getUpdate() {
        String version = this.getVersion();
        int index = version.indexOf(95);
        if (index <= 0) {
            return 0;
        }
        try {
            return Integer.parseInt(version.substring(index + 1));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String getVersion() {
        int index = this.value.indexOf(45);
        if (index <= 0) {
            return this.value;
        }
        return this.value.substring(0, index);
    }

    public String toString() {
        return this.value;
    }
}

