/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.settings;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.purplejs.core.internal.settings.SettingsImpl;
import io.purplejs.core.settings.Settings;
import io.purplejs.core.settings.SettingsBuilder;
import java.util.Map;
import java.util.Properties;

public final class SettingsBuilderImpl
implements SettingsBuilder {
    private final Map<String, String> map = Maps.newTreeMap();

    @Override
    public SettingsBuilder put(Properties properties) {
        return this.put((String)null, properties);
    }

    @Override
    public SettingsBuilder put(Map<String, String> map) {
        return this.put(null, map);
    }

    @Override
    public SettingsBuilder put(Settings settings) {
        return this.put(null, settings);
    }

    @Override
    public SettingsBuilder put(String key, Properties properties) {
        return this.put(key, (Map<String, String>)Maps.fromProperties((Properties)properties));
    }

    @Override
    public SettingsBuilder put(String key, Map<String, String> map) {
        map.forEach((oldKey, value) -> this.put(this.keyFromPrefix(key, (String)oldKey), (String)value));
        return this;
    }

    @Override
    public SettingsBuilder put(String key, Settings settings) {
        return this.put(key, settings.asMap());
    }

    @Override
    public SettingsBuilder put(String key, String value) {
        this.map.put(key.trim(), value.trim());
        return this;
    }

    private String keyFromPrefix(String prefix, String key) {
        return prefix != null ? prefix + "." + key : key;
    }

    @Override
    public SettingsBuilder put(String key, boolean value) {
        return this.put(key, String.valueOf(value));
    }

    @Override
    public SettingsBuilder put(String key, Number value) {
        return this.put(key, String.valueOf(value));
    }

    @Override
    public SettingsBuilder putArray(String key, String ... values) {
        return this.put(key, Joiner.on((char)',').join((Object[])values));
    }

    @Override
    public Settings build() {
        return new SettingsImpl((ImmutableMap<String, String>)ImmutableMap.copyOf(this.map));
    }
}

