/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.resource;

import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import io.purplejs.core.resource.Resource;
import io.purplejs.core.resource.ResourcePath;
import java.io.File;

final class FileResource
implements Resource {
    private final ResourcePath path;
    private final File file;

    FileResource(ResourcePath path, File file) {
        this.path = path;
        this.file = file;
    }

    @Override
    public ResourcePath getPath() {
        return this.path;
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public ByteSource getBytes() {
        return Files.asByteSource((File)this.file);
    }
}

