/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.nashorn;

import io.purplejs.core.internal.nashorn.NashornRuntime;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

final class NashornRuntimeImpl
implements NashornRuntime {
    private final ScriptEngine engine;
    private final ScriptObjectMirror arrayProto;
    private final ScriptObjectMirror objectProto;
    private final ScriptObjectMirror jsonProto;

    NashornRuntimeImpl(ScriptEngine engine) {
        this.engine = engine;
        Bindings bindings = this.engine.getBindings(100);
        this.arrayProto = (ScriptObjectMirror)bindings.get("Array");
        this.objectProto = (ScriptObjectMirror)bindings.get("Object");
        this.jsonProto = (ScriptObjectMirror)bindings.get("JSON");
    }

    @Override
    public ScriptEngine getEngine() {
        return this.engine;
    }

    @Override
    public ScriptObjectMirror newJsObject() {
        return (ScriptObjectMirror)this.objectProto.newObject(new Object[0]);
    }

    @Override
    public ScriptObjectMirror newJsArray() {
        return (ScriptObjectMirror)this.arrayProto.newObject(new Object[0]);
    }

    @Override
    public String toJsonString(Object value) {
        return (String)this.jsonProto.callMember("stringify", new Object[]{value});
    }

    @Override
    public ScriptObjectMirror parseJson(String value) {
        return (ScriptObjectMirror)this.jsonProto.callMember("parse", new Object[]{value});
    }
}

