/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.executor;

import com.google.common.collect.Maps;
import io.purplejs.core.Environment;
import io.purplejs.core.RunMode;
import io.purplejs.core.internal.cache.ScriptExportsCache;
import io.purplejs.core.internal.executor.ExecutionContextImpl;
import io.purplejs.core.internal.executor.InitScriptReader;
import io.purplejs.core.internal.executor.ScriptExecutor;
import io.purplejs.core.internal.nashorn.NashornRuntime;
import io.purplejs.core.internal.util.ErrorHelper;
import io.purplejs.core.internal.value.ScriptExportsImpl;
import io.purplejs.core.internal.value.ScriptValueFactory;
import io.purplejs.core.internal.value.ScriptValueFactoryImpl;
import io.purplejs.core.resource.Resource;
import io.purplejs.core.resource.ResourcePath;
import io.purplejs.core.util.IOHelper;
import io.purplejs.core.value.ScriptExports;
import io.purplejs.core.value.ScriptValue;
import java.util.Map;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.SimpleBindings;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public final class ScriptExecutorImpl
implements ScriptExecutor {
    private ScriptEngine engine;
    private Environment environment;
    private ScriptExportsCache exportsCache;
    private Map<ResourcePath, Object> mocks;
    private Map<ResourcePath, Runnable> disposers;
    private ScriptValueFactory scriptValueFactory;
    private NashornRuntime nashornRuntime;
    private Bindings global = new SimpleBindings();

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    public void setNashornRuntime(NashornRuntime nashornRuntime) {
        this.nashornRuntime = nashornRuntime;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void init() {
        this.mocks = Maps.newHashMap();
        this.disposers = Maps.newHashMap();
        this.exportsCache = new ScriptExportsCache();
        this.scriptValueFactory = new ScriptValueFactoryImpl(this.nashornRuntime);
        this.engine = this.nashornRuntime.getEngine();
        this.engine.setBindings(this.global, 200);
    }

    public void addGlobalVariables(Map<String, Object> variables) {
        this.global.putAll((Map<? extends String, ? extends Object>)variables);
    }

    @Override
    public ScriptExports executeMain(ResourcePath path) {
        this.expireCacheIfNeeded();
        Object exports = this.executeRequire(path);
        ScriptValue value = this.newScriptValue(exports);
        return new ScriptExportsImpl(path, value);
    }

    private void expireCacheIfNeeded() {
        if (RunMode.get() != RunMode.DEV) {
            return;
        }
        if (this.exportsCache.isExpired()) {
            this.exportsCache.clear();
            this.runDisposers();
        }
    }

    @Override
    public Object executeRequire(ResourcePath path) {
        Object mock = this.mocks.get(path);
        if (mock != null) {
            return mock;
        }
        Object cached = this.exportsCache.get(path);
        Resource resource = this.loadIfNeeded(path, cached);
        if (resource == null) {
            return cached;
        }
        Object result = this.requireJsOrJson(resource);
        this.exportsCache.put(resource, result);
        return result;
    }

    private Object requireJsOrJson(Resource resource) {
        String ext = resource.getPath().getExtension();
        if (ext.equals("json")) {
            return this.requireJson(resource);
        }
        return this.requireJs(resource);
    }

    private Object requireJs(Resource resource) {
        ResourcePath path = resource.getPath();
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("javax.script.filename", (Object)path.toString());
        ScriptObjectMirror func = (ScriptObjectMirror)this.doExecute(bindings, resource);
        return this.executeRequire(path, func);
    }

    private Object requireJson(Resource resource) {
        try {
            String text = IOHelper.readString(resource.getBytes());
            return this.nashornRuntime.parseJson(text);
        }
        catch (Exception e) {
            throw ErrorHelper.INSTANCE.handleError(e);
        }
    }

    @Override
    public ScriptValue newScriptValue(Object value) {
        return this.scriptValueFactory.newValue(value);
    }

    private Resource loadIfNeeded(ResourcePath key, Object cached) {
        if (cached == null) {
            return this.loadResource(key);
        }
        return null;
    }

    private Resource loadResource(ResourcePath key) {
        return this.environment.getResourceLoader().load(key);
    }

    private Object executeRequire(ResourcePath script, ScriptObjectMirror func) {
        try {
            ExecutionContextImpl context = new ExecutionContextImpl(this, script);
            Function<String, Object> requireFunc = context::require;
            Function<String, ResourcePath> resolveFunc = context::resolve;
            return func.call(null, new Object[]{context, requireFunc, resolveFunc, context.getLogger()});
        }
        catch (Exception e) {
            throw ErrorHelper.INSTANCE.handleError(e);
        }
    }

    private Object doExecute(Bindings bindings, Resource script) {
        try {
            String text = IOHelper.readString(script.getBytes());
            String source = InitScriptReader.getScript(text);
            return this.engine.eval(source, bindings);
        }
        catch (Exception e) {
            throw ErrorHelper.INSTANCE.handleError(e);
        }
    }

    @Override
    public void registerMock(ResourcePath path, Object value) {
        this.mocks.put(path, value);
    }

    @Override
    public void registerDisposer(ResourcePath path, Runnable callback) {
        this.disposers.put(path, callback);
    }

    private void runDisposers() {
        this.disposers.values().forEach(Runnable::run);
    }

    public void dispose() {
        this.runDisposers();
    }

    @Override
    public NashornRuntime getNashornRuntime() {
        return this.nashornRuntime;
    }
}

