/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.value;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.purplejs.core.internal.value.AbstractScriptValue;
import io.purplejs.core.internal.value.ScriptValueFactory;
import io.purplejs.core.value.ScriptValue;
import java.util.Set;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

final class ObjectScriptValue
extends AbstractScriptValue {
    private final ScriptValueFactory factory;
    private final ScriptObjectMirror value;

    ObjectScriptValue(ScriptValueFactory factory, ScriptObjectMirror value) {
        this.factory = factory;
        this.value = value;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public Set<String> getKeys() {
        return this.value.keySet();
    }

    @Override
    public boolean hasMember(String key) {
        return this.value.hasMember(key);
    }

    @Override
    public ScriptValue getMember(String key) {
        return this.factory.newValue(this.value.getMember(key));
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        for (String key : this.value.keySet()) {
            json.add(key, this.getMember(key).toJson());
        }
        return json;
    }

    @Override
    public Object getRaw() {
        return this.value;
    }
}

