/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.util;

import io.purplejs.core.exception.ProblemException;
import io.purplejs.core.resource.ResourcePath;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornException;

public final class ErrorHelper {
    public static final ErrorHelper INSTANCE = new ErrorHelper();

    public RuntimeException handleError(Exception e) {
        if (e instanceof ProblemException) {
            return (ProblemException)e;
        }
        if (e instanceof ScriptException) {
            return this.doHandleException((ScriptException)e);
        }
        if (e instanceof RuntimeException) {
            return this.doHandleException((RuntimeException)e);
        }
        return new RuntimeException(e);
    }

    private ProblemException doHandleException(ScriptException e) {
        ProblemException.Builder builder = ProblemException.newBuilder();
        Throwable cause = e.getCause();
        builder.cause(cause != null ? cause : e);
        builder.lineNumber(e.getLineNumber());
        builder.path(this.toResourcePath(e.getFileName()));
        return builder.build();
    }

    private RuntimeException doHandleException(RuntimeException e) {
        StackTraceElement elem = ErrorHelper.findScriptTraceElement(e);
        if (elem == null) {
            return e;
        }
        ProblemException.Builder builder = ProblemException.newBuilder();
        builder.cause(e);
        builder.lineNumber(elem.getLineNumber());
        builder.path(this.toResourcePath(elem.getFileName()));
        return builder.build();
    }

    private ResourcePath toResourcePath(String name) {
        return ResourcePath.from(name);
    }

    private static StackTraceElement findScriptTraceElement(RuntimeException e) {
        StackTraceElement[] elements = NashornException.getScriptFrames((Throwable)e);
        return elements.length > 0 ? elements[0] : null;
    }
}

