/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.settings;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.purplejs.core.internal.util.ConvertHelper;
import io.purplejs.core.settings.Settings;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

final class SettingsImpl
implements Settings {
    private final ImmutableMap<String, String> map;

    SettingsImpl(ImmutableMap<String, String> map) {
        this.map = map;
    }

    @Override
    public Optional<String> get(String key) {
        return Optional.ofNullable(this.map.get((Object)key));
    }

    @Override
    public <T> Optional<T> get(Class<T> type, String key) {
        return this.get(type, key, null);
    }

    @Override
    public <T> Optional<T> get(Class<T> type, String key, Function<String, T> converter) {
        Optional<String> value = this.get(key);
        return value.flatMap(str -> Optional.ofNullable(this.convert(type, (String)str, converter)));
    }

    @Override
    public List<String> getAsArray(String key) {
        String value = this.get(key).orElse("");
        return Lists.newArrayList((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value));
    }

    @Override
    public <T> List<T> getAsArray(Class<T> type, String key) {
        return this.getAsArray(type, key, null);
    }

    @Override
    public <T> List<T> getAsArray(Class<T> type, String key, Function<String, T> converter) {
        return this.getAsArray(key).stream().map(str -> this.convert(type, (String)str, converter)).filter(value -> value != null).collect(Collectors.toList());
    }

    private <T> T convert(Class<T> type, String value, Function<String, T> converter) {
        try {
            if (converter != null) {
                return converter.apply(value);
            }
            return ConvertHelper.INSTANCE.convert(value, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Settings getAsSettings(String key) {
        String prefix = key + ".";
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.map.forEach((oldKey, value) -> {
            if (oldKey.startsWith(prefix)) {
                builder.put((Object)oldKey.substring(prefix.length()), value);
            }
        });
        return new SettingsImpl((ImmutableMap<String, String>)builder.build());
    }

    @Override
    public Map<String, String> asMap() {
        return this.map;
    }

    public String toString() {
        return this.map.toString();
    }
}

