/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.resource;

import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import io.purplejs.core.resource.Resource;
import io.purplejs.core.resource.ResourcePath;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

final class UrlResource
implements Resource {
    private final ResourcePath path;
    private final URL url;

    UrlResource(ResourcePath path, URL url) {
        this.path = path;
        this.url = url;
    }

    @Override
    public ResourcePath getPath() {
        return this.path;
    }

    @Override
    public long getSize() {
        URLConnection conn = this.openConnection();
        return conn != null ? (long)conn.getContentLength() : -1L;
    }

    @Override
    public long getLastModified() {
        URLConnection conn = this.openConnection();
        return conn != null ? conn.getLastModified() : -1L;
    }

    @Override
    public ByteSource getBytes() {
        return Resources.asByteSource((URL)this.url);
    }

    private URLConnection openConnection() {
        try {
            URLConnection connection = this.url.openConnection();
            connection.connect();
            return connection;
        }
        catch (IOException e) {
            return null;
        }
    }
}

