/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.registry;

import com.google.common.collect.ImmutableMap;
import io.purplejs.core.registry.Registry;
import java.util.function.Supplier;

final class RegistryImpl
implements Registry {
    private final ImmutableMap<Class, Supplier> map;

    RegistryImpl(ImmutableMap<Class, Supplier> map) {
        this.map = map;
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        return this.getProvider(type).get();
    }

    @Override
    public <T> T getInstanceOrNull(Class<T> type) {
        Supplier<T> binding = this.getBindingOrNull(type);
        return binding != null ? (T)binding.get() : null;
    }

    @Override
    public <T> Supplier<T> getProvider(Class<T> type) {
        return this.getBinding(type);
    }

    private <T> Supplier<T> getBinding(Class<T> type) {
        Supplier<T> binding = this.getBindingOrNull(type);
        if (binding != null) {
            return binding;
        }
        throw new IllegalArgumentException(String.format("No binding of type [%s]", type.getName()));
    }

    private <T> Supplier<T> getBindingOrNull(Class<T> type) {
        return (Supplier)this.map.get(type);
    }
}

