/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.lib;

import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import io.purplejs.core.resource.Resource;
import io.purplejs.core.resource.ResourceLoader;
import io.purplejs.core.resource.ResourcePath;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;

public final class CoreLibHelper {
    private ByteSource toByteSource(Object value) {
        if (value instanceof ByteSource) {
            return (ByteSource)value;
        }
        return this.newStream(value.toString());
    }

    private CharSource toCharSource(Object value) {
        return this.toByteSource(value).asCharSource(Charsets.UTF_8);
    }

    public ByteSource newStream(String value) {
        return ByteSource.wrap((byte[])value.getBytes(Charsets.UTF_8));
    }

    public String readText(Object stream) throws Exception {
        return this.toCharSource(stream).read();
    }

    public List<String> readLines(Object stream) throws Exception {
        return this.toCharSource(stream).readLines();
    }

    public long getStreamSize(Object stream) throws Exception {
        return this.toByteSource(stream).size();
    }

    public void processLines(Object stream, final Consumer<String> callback) throws Exception {
        CharSource source = this.toCharSource(stream);
        source.readLines((LineProcessor)new LineProcessor<Object>(){

            public boolean processLine(String line) throws IOException {
                callback.accept(line);
                return true;
            }

            public Object getResult() {
                return null;
            }
        });
    }

    private ResourcePath toPath(Object path) {
        return path instanceof ResourcePath ? (ResourcePath)path : ResourcePath.from(path.toString());
    }

    public ByteSource loadResource(ResourceLoader loader, Object path) {
        Resource resource = loader.loadOrNull(this.toPath(path));
        return resource != null ? resource.getBytes() : null;
    }
}

