/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.executor;

import io.purplejs.core.context.ScriptLogger;
import io.purplejs.core.resource.ResourcePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ScriptLoggerImpl
implements ScriptLogger {
    private static final String PREFIX = "js";
    private final Logger logger;

    ScriptLoggerImpl(ResourcePath path) {
        this(ScriptLoggerImpl.pathToLogger(path));
    }

    ScriptLoggerImpl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void debug(String message, Object ... args) {
        this.logger.debug(ScriptLoggerImpl.format(message, args));
    }

    @Override
    public void info(String message, Object ... args) {
        this.logger.info(ScriptLoggerImpl.format(message, args));
    }

    @Override
    public void warning(String message, Object ... args) {
        this.logger.warn(ScriptLoggerImpl.format(message, args));
    }

    @Override
    public void error(String message, Object ... args) {
        this.logger.error(ScriptLoggerImpl.format(message, args));
    }

    static String format(String message, Object ... args) {
        if (args.length > 0) {
            return String.format(message, args);
        }
        return message;
    }

    static Logger pathToLogger(ResourcePath path) {
        String name = path.toString().replaceAll("(.+)\\..+", "$1").replace('/', '.');
        return LoggerFactory.getLogger((String)(PREFIX + name));
    }
}

