/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.cache;

import com.google.common.collect.Maps;
import io.purplejs.core.internal.cache.ScriptExportEntry;
import io.purplejs.core.resource.Resource;
import io.purplejs.core.resource.ResourcePath;
import java.util.Map;

public final class ScriptExportsCache {
    private final Map<ResourcePath, ScriptExportEntry> cache = Maps.newConcurrentMap();

    public Object get(ResourcePath key) {
        ScriptExportEntry entry = this.cache.get(key);
        return entry != null ? entry.value : null;
    }

    public void put(Resource resource, Object value) {
        ResourcePath key = resource.getPath();
        this.cache.put(key, new ScriptExportEntry(resource, value));
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean isExpired() {
        for (ScriptExportEntry entry : this.cache.values()) {
            if (!entry.isExpired()) continue;
            return true;
        }
        return false;
    }
}

