/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.purplejs.core.Engine;
import io.purplejs.core.internal.CompositeModule;
import io.purplejs.core.internal.executor.ScriptExecutorImpl;
import io.purplejs.core.internal.nashorn.NashornRuntime;
import io.purplejs.core.internal.nashorn.NashornRuntimeFactory;
import io.purplejs.core.registry.Registry;
import io.purplejs.core.resource.ResourceLoader;
import io.purplejs.core.resource.ResourcePath;
import io.purplejs.core.settings.Settings;
import io.purplejs.core.value.ScriptExports;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

final class EngineImpl
implements Engine {
    ResourceLoader resourceLoader;
    ClassLoader classLoader;
    ImmutableMap<String, String> config;
    ImmutableMap<String, Object> globalVariables;
    Registry registry;
    CompositeModule module;
    Settings settings;
    ImmutableList<File> devSourceDirs;
    private final ScriptExecutorImpl executor = new ScriptExecutorImpl();

    EngineImpl() {
    }

    @Override
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        return this.registry.getInstance(type);
    }

    @Override
    public <T> T getInstanceOrNull(Class<T> type) {
        return this.registry.getInstanceOrNull(type);
    }

    @Override
    public <T> Supplier<T> getProvider(Class<T> type) {
        return this.registry.getProvider(type);
    }

    @Override
    public ScriptExports require(ResourcePath path) {
        return this.executor.executeMain(path);
    }

    @Override
    public List<File> getDevSourceDirs() {
        return this.devSourceDirs;
    }

    @Override
    public void dispose() {
        this.module.dispose(this);
        this.executor.dispose();
    }

    void init() {
        NashornRuntimeFactory nashornRuntimeFactory = new NashornRuntimeFactory();
        NashornRuntime nashornRuntime = nashornRuntimeFactory.newRuntime(this.classLoader);
        this.executor.setEnvironment(this);
        this.executor.setNashornRuntime(nashornRuntime);
        this.executor.init();
        this.executor.addGlobalVariables((Map<String, Object>)this.globalVariables);
        this.module.init(this);
    }
}

