/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.exception;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.purplejs.core.resource.ResourcePath;
import java.util.Collection;
import java.util.List;

public final class ProblemException
extends RuntimeException {
    private ResourcePath path;
    private final int lineNumber;
    private final ImmutableList<String> callStack;

    private ProblemException(Builder builder) {
        super(builder.message);
        this.path = builder.path;
        this.lineNumber = builder.lineNumber;
        this.callStack = ImmutableList.copyOf((Collection)builder.callStack);
        if (builder.cause != null) {
            this.initCause(builder.cause);
        }
    }

    public ResourcePath getPath() {
        return this.path;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public List<String> getCallStack() {
        return this.callStack;
    }

    public ProblemException getInnerError() {
        return this.getInnerError(this.getCause());
    }

    private ProblemException getInnerError(Throwable cause) {
        if (cause == null) {
            return this;
        }
        if (cause instanceof ProblemException) {
            return (ProblemException)cause;
        }
        return this.getInnerError(cause.getCause());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String message;
        private Throwable cause;
        private ResourcePath path;
        private int lineNumber = -1;
        private final List<String> callStack = Lists.newArrayList();

        private Builder() {
        }

        public Builder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public Builder message(String message, Object ... args) {
            this.message = args.length > 0 ? String.format(message, args) : message;
            return this;
        }

        public Builder path(ResourcePath path) {
            this.path = path;
            return this;
        }

        public Builder lineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder callLine(String name, int lineNumber) {
            this.callStack.add(String.format("%s at line %s", name, lineNumber));
            return this;
        }

        public ProblemException build() {
            if (this.message == null) {
                String string = this.message = this.cause != null ? this.cause.getMessage() : null;
            }
            if (this.message == null) {
                this.message = "Empty message in exception";
            }
            return new ProblemException(this);
        }
    }
}

