/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.mock;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import io.purplejs.core.mock.MockResource;
import io.purplejs.core.resource.Resource;
import io.purplejs.core.resource.ResourceLoader;
import io.purplejs.core.resource.ResourcePath;
import java.util.Map;

public final class MockResourceLoader
implements ResourceLoader {
    private final Map<ResourcePath, Resource> map = Maps.newHashMap();

    @Override
    public Resource loadOrNull(ResourcePath path) {
        return this.map.get(path);
    }

    public MockResource addResource(String path, String text) {
        return this.addResource(ResourcePath.from(path), text);
    }

    public MockResource addResource(String path, byte[] bytes) {
        return this.addResource(ResourcePath.from(path), bytes);
    }

    public MockResource addResource(ResourcePath path, String text) {
        return this.addResource(path, text.getBytes(Charsets.UTF_8));
    }

    public MockResource addResource(ResourcePath path, byte[] bytes) {
        MockResource resource = new MockResource(path, bytes);
        this.map.put(path, resource);
        return resource;
    }
}

