/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.value;

import io.purplejs.core.internal.nashorn.NashornRuntime;
import io.purplejs.core.internal.util.ErrorHelper;
import io.purplejs.core.internal.util.JsObjectConverter;
import io.purplejs.core.internal.value.AbstractScriptValue;
import io.purplejs.core.internal.value.ScriptValueFactory;
import io.purplejs.core.value.ScriptValue;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

final class FunctionScriptValue
extends AbstractScriptValue {
    private final ScriptValueFactory factory;
    private final ScriptObjectMirror value;
    private final NashornRuntime runtime;

    FunctionScriptValue(ScriptValueFactory factory, ScriptObjectMirror value, NashornRuntime runtime) {
        this.factory = factory;
        this.value = value;
        this.runtime = runtime;
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public ScriptValue call(Object ... args) {
        try {
            Object[] jsArray = this.convertArgs(args);
            Object result = this.value.call(null, jsArray);
            return this.factory.newValue(result);
        }
        catch (Exception e) {
            throw ErrorHelper.INSTANCE.handleError(e);
        }
    }

    private Object[] convertArgs(Object ... args) {
        JsObjectConverter converter = new JsObjectConverter(this.runtime);
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = converter.toJs(args[i]);
        }
        return result;
    }

    @Override
    public Object getRaw() {
        return this.value;
    }
}

