/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.util;

import io.purplejs.core.internal.json.ScriptJsonGenerator;
import io.purplejs.core.internal.nashorn.NashornHelper;
import io.purplejs.core.internal.nashorn.NashornRuntime;
import io.purplejs.core.json.JsonSerializable;
import java.util.List;
import java.util.Map;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public final class JsObjectConverter {
    private final NashornRuntime runtime;

    public JsObjectConverter(NashornRuntime runtime) {
        this.runtime = runtime;
    }

    public Object toJs(Object value) {
        if (value instanceof JsonSerializable) {
            return this.toJs((JsonSerializable)value);
        }
        if (value instanceof List) {
            return this.toJs((List)value);
        }
        if (value instanceof Map) {
            return this.toJs((Map)value);
        }
        return value;
    }

    private Object toJs(JsonSerializable value) {
        ScriptJsonGenerator generator = new ScriptJsonGenerator(this.runtime);
        value.serialize(generator);
        return generator.getRoot();
    }

    private Object toJs(List list) {
        ScriptObjectMirror array = this.runtime.newJsArray();
        for (Object element : list) {
            NashornHelper.INSTANCE.addToArray(array, this.toJs(element));
        }
        return array;
    }

    private Object toJs(Map<?, ?> map) {
        ScriptObjectMirror result = this.runtime.newJsObject();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            NashornHelper.INSTANCE.addToObject(result, entry.getKey().toString(), this.toJs(entry.getValue()));
        }
        return result;
    }
}

