/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.util;

import java.util.function.Function;

public final class ConvertHelper {
    public static final ConvertHelper INSTANCE = new ConvertHelper();
    private static final String TRUE_FLAGS = "true|yes|on|1";

    public <T> T convert(Object value, Class<T> type) {
        Object result = this.doConvert(value, type);
        return result != null ? (T)type.cast(result) : null;
    }

    private Object doConvert(Object value, Class type) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return value;
        }
        if (type == Boolean.class) {
            return this.convertToBoolean(value);
        }
        if (type == Byte.class) {
            return this.convertToByte(value);
        }
        if (type == Double.class) {
            return this.convertToDouble(value);
        }
        if (type == Float.class) {
            return this.convertToFloat(value);
        }
        if (type == Integer.class) {
            return this.convertToInteger(value);
        }
        if (type == Long.class) {
            return this.convertToLong(value);
        }
        if (type == Short.class) {
            return this.convertToShort(value);
        }
        if (type == String.class) {
            return this.convertToString(value);
        }
        throw this.noSuchConverter(value.getClass(), type);
    }

    private Boolean convertToBoolean(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        return TRUE_FLAGS.contains(value.toString());
    }

    private <T> T convertToNumber(Class<T> type, Object value, Function<Number, T> fromNumber, Function<String, T> parser) {
        if (value instanceof Number) {
            return fromNumber.apply((Number)value);
        }
        try {
            return parser.apply(value.toString());
        }
        catch (Exception e) {
            throw this.convertFailure(value.getClass(), type, e);
        }
    }

    private Byte convertToByte(Object value) {
        return this.convertToNumber(Byte.class, value, Number::byteValue, Byte::parseByte);
    }

    private Double convertToDouble(Object value) {
        return this.convertToNumber(Double.class, value, Number::doubleValue, Double::parseDouble);
    }

    private Float convertToFloat(Object value) {
        return this.convertToNumber(Float.class, value, Number::floatValue, Float::parseFloat);
    }

    private Integer convertToInteger(Object value) {
        return this.convertToNumber(Integer.class, value, Number::intValue, Integer::parseInt);
    }

    private Long convertToLong(Object value) {
        return this.convertToNumber(Long.class, value, Number::longValue, Long::parseLong);
    }

    private Short convertToShort(Object value) {
        return this.convertToNumber(Short.class, value, Number::shortValue, Short::parseShort);
    }

    private String convertToString(Object value) {
        return value.toString();
    }

    private IllegalArgumentException noSuchConverter(Class<?> source, Class<?> target) {
        return new IllegalArgumentException(String.format("No such converter for %s -> %s", source.getName(), target.getName()));
    }

    private IllegalArgumentException convertFailure(Class<?> source, Class<?> target, Throwable cause) {
        return new IllegalArgumentException(String.format("Failed to convert %s -> %s", source.getName(), target.getName()), cause);
    }
}

