/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.resource;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import io.purplejs.core.internal.resource.UrlResource;
import io.purplejs.core.resource.Resource;
import io.purplejs.core.resource.ResourceLoader;
import io.purplejs.core.resource.ResourcePath;
import java.net.URL;

final class ClassLoaderResourceLoader
implements ResourceLoader {
    private final ClassLoader loader;
    private final String basePath;

    ClassLoaderResourceLoader(ClassLoader loader, String basePath) {
        this.loader = loader;
        this.basePath = this.normalizePath(basePath);
    }

    @Override
    public Resource loadOrNull(ResourcePath path) {
        String location = this.resolveLocation(path);
        URL url = this.loader.getResource(location);
        if (url == null) {
            return null;
        }
        return new UrlResource(path, url);
    }

    private String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        Iterable parts = Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)path);
        return Strings.emptyToNull((String)Joiner.on((char)'/').join(parts));
    }

    private String resolveLocation(ResourcePath path) {
        if (this.basePath == null) {
            return path.getPath().substring(1);
        }
        return this.normalizePath(this.basePath + "/" + path.getPath());
    }
}

