/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.resolver;

import com.google.common.collect.Lists;
import io.purplejs.core.internal.resolver.ResourcePathResolver;
import io.purplejs.core.resource.ResourceLoader;
import io.purplejs.core.resource.ResourcePath;
import java.util.ArrayList;
import java.util.List;

public final class RequirePathResolver
implements ResourcePathResolver {
    private final ResourceLoader loader;
    private final ResourcePath baseDir;

    public RequirePathResolver(ResourceLoader loader, ResourcePath baseDir) {
        this.loader = loader;
        this.baseDir = baseDir;
    }

    @Override
    public ResourcePath resolve(String path) {
        if (path.startsWith("/") || path.startsWith("./") || path.startsWith("../")) {
            return this.resolveFileOrDir(this.baseDir, path);
        }
        return this.resolveSearchPath(path);
    }

    private boolean exists(ResourcePath path) {
        return this.loader.exists(path);
    }

    private ResourcePath resolveFileOrDir(ResourcePath path) {
        ResourcePath resolved = this.resolveAsFile(path);
        if (resolved != null) {
            return resolved;
        }
        return this.resolveAsDir(path);
    }

    private ResourcePath resolveFileOrDir(ResourcePath dir, String path) {
        return this.resolveFileOrDir(dir.resolve(path));
    }

    private ResourcePath resolveAsFile(ResourcePath file) {
        if (this.exists(file)) {
            return file;
        }
        ResourcePath path1 = ResourcePath.from(file + ".js");
        if (this.exists(path1)) {
            return path1;
        }
        ResourcePath path2 = ResourcePath.from(file + ".json");
        if (this.exists(path2)) {
            return path2;
        }
        return null;
    }

    private ResourcePath resolveAsDir(ResourcePath dir) {
        ResourcePath path1 = ResourcePath.from(dir + "/index.js");
        if (this.exists(path1)) {
            return path1;
        }
        ResourcePath path2 = ResourcePath.from(dir + "/index.json");
        if (this.exists(path2)) {
            return path2;
        }
        return null;
    }

    private ResourcePath resolveSearchPath(String path) {
        for (ResourcePath searchPath : RequirePathResolver.findSearchPaths()) {
            ResourcePath resourcePath = this.resolveFileOrDir(searchPath, path);
            if (resourcePath == null) continue;
            return resourcePath;
        }
        return null;
    }

    private static List<ResourcePath> findSearchPaths() {
        ArrayList paths = Lists.newArrayList();
        paths.add(ResourcePath.from("/lib"));
        return paths;
    }
}

