/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.json;

import io.purplejs.core.json.JsonGenerator;
import io.purplejs.core.json.JsonSerializable;
import io.purplejs.core.value.ScriptValue;
import java.util.Stack;

public abstract class AbstractJsonGenerator
implements JsonGenerator {
    private final Stack<Object> stack = new Stack();
    private Object current;
    private Object root;

    public final Object getRoot() {
        return this.root;
    }

    protected abstract Object newMap();

    protected abstract Object newArray();

    protected abstract boolean isMap(Object var1);

    protected abstract boolean isArray(Object var1);

    private void checkIfMap() {
        if (!this.isMap(this.current)) {
            throw new IllegalArgumentException("Current object should be of type map");
        }
    }

    private void checkIfArray() {
        if (!this.isArray(this.current)) {
            throw new IllegalArgumentException("Current object should be of type array");
        }
    }

    private Object putInMap(String key, Object value) {
        this.checkIfMap();
        this.putInMap(this.current, key, value);
        return value;
    }

    protected abstract void putInMap(Object var1, String var2, Object var3);

    private Object addToArray(Object value) {
        this.checkIfArray();
        this.addToArray(this.current, value);
        return value;
    }

    protected abstract void addToArray(Object var1, Object var2);

    private void setCurrent(Object object) {
        this.stack.push(this.current);
        this.current = object;
        if (this.root == null) {
            this.root = this.current;
        }
    }

    @Override
    public final JsonGenerator array() {
        if (this.current == null) {
            this.setCurrent(this.newArray());
        } else {
            this.setCurrent(this.addToArray(this.newArray()));
        }
        return this;
    }

    @Override
    public final JsonGenerator array(String key) {
        this.setCurrent(this.putInMap(key, this.newArray()));
        return this;
    }

    @Override
    public final JsonGenerator map() {
        if (this.current == null) {
            this.setCurrent(this.newMap());
        } else {
            this.setCurrent(this.addToArray(this.newMap()));
        }
        return this;
    }

    @Override
    public final JsonGenerator map(String key) {
        this.setCurrent(this.putInMap(key, this.newMap()));
        return this;
    }

    @Override
    public final JsonGenerator value(Object value) {
        this.addToArray(this.convertValue(value));
        return this;
    }

    @Override
    public final JsonGenerator value(String key, Object value) {
        this.putInMap(key, this.convertValue(value));
        return this;
    }

    @Override
    public final JsonGenerator end() {
        if (!this.stack.isEmpty()) {
            this.current = this.stack.pop();
        }
        return this;
    }

    private Object convertValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonSerializable) {
            return this.convertValue((JsonSerializable)value);
        }
        if (value instanceof ScriptValue) {
            return this.convertValue(((ScriptValue)value).getRaw());
        }
        return value;
    }

    private Object convertValue(JsonSerializable value) {
        AbstractJsonGenerator generator = this.newGenerator();
        value.serialize(generator);
        return generator.getRoot();
    }

    protected abstract AbstractJsonGenerator newGenerator();
}

