/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal.executor;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;

final class InitScriptReader {
    private static final InitScriptReader INSTANCE = new InitScriptReader();
    private final String init;

    private InitScriptReader() {
        try {
            this.init = this.loadScript();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load init.js", e);
        }
    }

    static String getScript(String script) {
        return InitScriptReader.INSTANCE.init.replace("/*__script__*/", script);
    }

    private String loadScript() throws Exception {
        URL url = this.getClass().getResource("init.js");
        List lines = Resources.readLines((URL)url, (Charset)Charsets.UTF_8);
        return Joiner.on((String)"").join((Iterable)lines);
    }
}

