/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.core.internal;

import com.google.common.collect.Lists;
import io.purplejs.core.Engine;
import io.purplejs.core.EngineBinder;
import io.purplejs.core.EngineModule;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;

final class CompositeModule
implements EngineModule {
    private final List<EngineModule> list = Lists.newArrayList();
    private final List<Consumer<Engine>> initializerList = Lists.newArrayList();
    private final List<Consumer<Engine>> disposerList = Lists.newArrayList();

    CompositeModule() {
    }

    void autoLoad() {
        ServiceLoader.load(EngineModule.class).forEach(this::add);
    }

    void add(EngineModule module) {
        this.list.add(module);
    }

    void init(Engine engine) {
        this.initializerList.forEach(initializer -> this.init((Consumer<Engine>)initializer, engine));
    }

    private void init(Consumer<Engine> initializer, Engine engine) {
        initializer.accept(engine);
    }

    void dispose(Engine engine) {
        this.disposerList.forEach(disposer -> this.dispose((Consumer<Engine>)disposer, engine));
    }

    private void dispose(Consumer<Engine> disposer, Engine engine) {
        disposer.accept(engine);
    }

    @Override
    public void configure(EngineBinder binder) {
        this.list.forEach(module -> module.configure(binder));
    }

    void addInitializer(Consumer<Engine> initializer) {
        this.initializerList.add(initializer);
    }

    void addDisposer(Consumer<Engine> disposer) {
        this.disposerList.add(disposer);
    }
}

