/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.boot;

import io.purplejs.boot.internal.BannerPrinter;
import io.purplejs.boot.internal.config.ConfigBuilder;
import io.purplejs.boot.internal.server.ServerConfigurator;
import io.purplejs.core.settings.Settings;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class MainApp {
    private Server server;

    public void start() throws Exception {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MainApp.this.stop();
            }
        });
        System.setProperty("java.net.preferIPv4Stack", "true");
        new BannerPrinter().printBanner();
        Settings settings = new ConfigBuilder().build();
        ServerConfigurator serverConfigurator = new ServerConfigurator();
        serverConfigurator.configure(settings);
        this.server = serverConfigurator.getServer();
        this.server.start();
    }

    public int getPort() {
        return ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
    }

    public void stop() {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String ... args) throws Exception {
        new MainApp().start();
    }
}

