/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.boot.internal.request;

import com.google.common.io.ByteSource;
import io.purplejs.boot.internal.request.MultipartFormFactory;
import io.purplejs.core.exception.ExceptionHelper;
import io.purplejs.core.util.IOHelper;
import io.purplejs.http.Request;
import io.purplejs.http.RequestBuilder;
import io.purplejs.http.multipart.MultipartForm;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public final class RequestFactory {
    private HttpServletRequest request;
    private boolean webSocket;

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setWebSocket(boolean webSocket) {
        this.webSocket = webSocket;
    }

    public Request create() {
        RequestBuilder builder = RequestBuilder.newBuilder();
        builder.method(this.request.getMethod());
        builder.uri(this.request.getRequestURL().toString());
        builder.webSocket(this.webSocket);
        builder.raw((Object)this.request);
        builder.contentLength((long)this.request.getContentLength());
        builder.contentType(this.request.getContentType());
        builder.body(this.readBody());
        this.addParameters(builder);
        this.addHeaders(builder);
        this.addCookies(builder);
        builder.multipart(this.readMultipart());
        return builder.build();
    }

    private void addHeaders(RequestBuilder builder) {
        Enumeration e = this.request.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            builder.header(key, this.request.getHeader(key));
        }
    }

    private void addParameters(RequestBuilder builder) {
        Enumeration e = this.request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            for (String value : this.request.getParameterValues(key)) {
                builder.parameter(key, value);
            }
        }
    }

    private void addCookies(RequestBuilder builder) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            builder.cookie(cookie.getName(), cookie.getValue());
        }
    }

    private boolean isMultipartForm() {
        String type = this.request.getContentType();
        return type != null && type.startsWith("multipart/form-data");
    }

    private ByteSource readBody() {
        if (this.isMultipartForm()) {
            return null;
        }
        return RequestFactory.readBody(this.request);
    }

    static ByteSource readBody(HttpServletRequest req) {
        return (ByteSource)ExceptionHelper.wrap(() -> IOHelper.toByteSource((InputStream)req.getInputStream()));
    }

    private MultipartForm readMultipart() {
        if (!this.isMultipartForm()) {
            return null;
        }
        return RequestFactory.readMultipart(this.request);
    }

    static MultipartForm readMultipart(HttpServletRequest req) {
        return (MultipartForm)ExceptionHelper.wrap(() -> new MultipartFormFactory().create(req.getParts()));
    }
}

