/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.boot.internal.request;

import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import com.google.common.net.MediaType;
import io.purplejs.boot.internal.request.PartByteSource;
import io.purplejs.core.exception.ExceptionHelper;
import io.purplejs.http.multipart.MultipartItem;
import javax.servlet.http.Part;

final class MultipartItemImpl
implements MultipartItem {
    private final Part part;
    private final ByteSource bytes;

    MultipartItemImpl(Part part) {
        this.part = part;
        this.bytes = new PartByteSource(this.part);
    }

    public String getName() {
        return this.part.getName();
    }

    public String getFileName() {
        return this.part.getSubmittedFileName();
    }

    public MediaType getContentType() {
        String itemContentType = this.part.getContentType();
        return itemContentType != null ? MediaType.parse((String)itemContentType) : null;
    }

    public ByteSource getBytes() {
        return this.bytes;
    }

    public String getAsString() {
        try {
            return this.bytes.asCharSource(Charsets.UTF_8).read();
        }
        catch (Exception e) {
            throw ExceptionHelper.unchecked((Throwable)e);
        }
    }

    public long getSize() {
        return this.part.getSize();
    }
}

