/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.boot.internal.websocket;

import com.google.common.io.ByteSource;
import io.purplejs.core.value.ScriptValue;
import io.purplejs.http.websocket.WebSocketSession;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebSocketSessionImpl
implements WebSocketSession {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketSessionImpl.class);
    private final String id = UUID.randomUUID().toString();
    String group;
    ScriptValue attributes;
    Session raw;

    WebSocketSessionImpl() {
    }

    public String getId() {
        return this.id;
    }

    public String getGroup() {
        return this.group;
    }

    public ScriptValue getAttributes() {
        return this.attributes;
    }

    public void close() {
        this.raw.close();
    }

    public void close(int code, String reason) {
        this.raw.close(code, reason);
    }

    public boolean isOpen() {
        return this.raw.isOpen();
    }

    public String getSubProtocol() {
        return this.raw.getUpgradeResponse().getAcceptedSubProtocol();
    }

    private RemoteEndpoint getRemote() {
        try {
            return this.raw.getRemote();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void send(String message) {
        RemoteEndpoint endpoint = this.getRemote();
        if (endpoint == null) {
            return;
        }
        try {
            endpoint.sendString(message);
        }
        catch (Exception e) {
            LOG.error("Failed to send web-socket message", (Throwable)e);
        }
    }

    public void send(ByteSource bytes) {
        RemoteEndpoint endpoint = this.getRemote();
        if (endpoint == null) {
            return;
        }
        try {
            ByteBuffer buffer = ByteBuffer.wrap(bytes.read());
            endpoint.sendBytes(buffer);
        }
        catch (Exception e) {
            LOG.error("Failed to send web-socket message", (Throwable)e);
        }
    }

    public Object getRaw() {
        return this.raw;
    }
}

