/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.boot.internal.server;

import io.purplejs.boot.internal.config.Configurable;
import io.purplejs.core.Engine;
import io.purplejs.core.EngineBuilder;
import io.purplejs.core.RunMode;
import io.purplejs.core.settings.Settings;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EngineConfigurator
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(EngineConfigurator.class);
    private Engine engine;

    public Engine getEngine() {
        return this.engine;
    }

    @Override
    public void configure(Settings settings) {
        EngineBuilder builder = EngineBuilder.newBuilder();
        this.configure(settings, builder);
        this.engine = builder.build();
    }

    private void configure(Settings settings, EngineBuilder builder) {
        builder.classLoader(this.getClass().getClassLoader());
        builder.settings(settings.getAsSettings("app"));
        this.configureDevMode(settings, builder);
    }

    private void configureDevMode(Settings settings, EngineBuilder builder) {
        RunMode runMode = RunMode.get();
        if (runMode != RunMode.DEV) {
            return;
        }
        List devSourceDirs = settings.getAsArray(File.class, "devSourceDirs", File::new);
        devSourceDirs.forEach(arg_0 -> ((EngineBuilder)builder).devSourceDir(arg_0));
        LOG.info("Running in DEV mode. Do not use in production!");
        LOG.info("Monitoring the following directories (devSourceDirs) for changes:");
        devSourceDirs.forEach(file -> LOG.info("*#* {} ", file));
    }
}

