/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.boot.internal.websocket;

import com.google.common.io.ByteSource;
import io.purplejs.boot.internal.websocket.WebSocketSessionImpl;
import io.purplejs.http.handler.HttpHandler;
import io.purplejs.http.websocket.WebSocketConfig;
import io.purplejs.http.websocket.WebSocketEvent;
import io.purplejs.http.websocket.WebSocketEventBuilder;
import io.purplejs.http.websocket.WebSocketSession;
import java.util.Set;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public final class WebSocketHandler
implements WebSocketCreator,
WebSocketListener {
    private final WebSocketConfig config;
    private final HttpHandler handler;
    private WebSocketSessionImpl session;

    public WebSocketHandler(HttpHandler handler, WebSocketConfig config) {
        this.config = config;
        this.handler = handler;
    }

    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse res) {
        Set allowSubProtocols = this.config.getSubProtocols();
        if (allowSubProtocols.isEmpty()) {
            return this.doCreateWebSocket();
        }
        for (String protocol : req.getSubProtocols()) {
            if (!allowSubProtocols.contains(protocol)) continue;
            res.setAcceptedSubProtocol(protocol);
            return this.doCreateWebSocket();
        }
        return null;
    }

    private WebSocketListener doCreateWebSocket() {
        return this;
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        byte[] bytes = new byte[len];
        System.arraycopy(payload, offset, bytes, 0, len);
        WebSocketEvent event = this.newEventBuilder().binaryEvent(ByteSource.wrap((byte[])bytes)).build();
        this.handleEvent(event);
    }

    public void onWebSocketText(String message) {
        WebSocketEvent event = this.newEventBuilder().messageEvent(message).build();
        this.handleEvent(event);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        WebSocketEvent event = this.newEventBuilder().closeEvent(statusCode, reason).build();
        this.handleEvent(event);
    }

    public void onWebSocketConnect(Session session) {
        session.setIdleTimeout(this.config.getTimeout());
        this.session = this.newSession(session);
        WebSocketEvent event = this.newEventBuilder().openEvent().build();
        this.handleEvent(event);
    }

    public void onWebSocketError(Throwable cause) {
        WebSocketEvent event = this.newEventBuilder().errorEvent(cause).build();
        this.handleEvent(event);
    }

    private WebSocketEventBuilder newEventBuilder() {
        WebSocketEventBuilder builder = WebSocketEventBuilder.newBuilder();
        builder.session((WebSocketSession)this.session);
        return builder;
    }

    private WebSocketSessionImpl newSession(Session session) {
        WebSocketSessionImpl result = new WebSocketSessionImpl();
        result.group = this.config.getGroup();
        result.attributes = this.config.getAttributes();
        result.raw = session;
        return result;
    }

    private void handleEvent(WebSocketEvent event) {
        this.handler.handleEvent(event);
    }
}

