/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.boot.internal.config;

import io.purplejs.core.settings.Settings;
import io.purplejs.core.settings.SettingsBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class ConfigBuilder {
    private final SettingsBuilder builder = SettingsBuilder.newBuilder();

    public ConfigBuilder() {
        this.builder.put(System.getProperties());
        this.builder.put("env", System.getenv());
        this.load(this.getClass(), "default.properties");
        this.load(this.getClass().getClassLoader(), "config.properties");
        this.applyOverrides();
    }

    public Settings build() {
        return this.builder.build();
    }

    private ConfigBuilder load(File file) {
        if (!file.isFile()) {
            return this;
        }
        try {
            this.doLoad(file.getPath(), new FileInputStream(file));
            return this;
        }
        catch (IOException e) {
            return this;
        }
    }

    private ConfigBuilder load(ClassLoader loader, String path) {
        InputStream in = loader.getResourceAsStream(path);
        if (in == null) {
            return this;
        }
        this.doLoad("classpath:" + path, in);
        return this;
    }

    private ConfigBuilder load(Class context, String path) {
        String fullPath = context.getName().replace('.', '/') + "/" + path;
        return this.load(context.getClassLoader(), fullPath);
    }

    private void doLoad(String path, InputStream in) {
        try {
            Properties props = new Properties();
            props.load(in);
            this.builder.put(props);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading [" + path + "]", e);
        }
    }

    private ConfigBuilder applyOverrides() {
        this.builder.put(SettingsBuilder.newBuilder().put(System.getProperties()).build().getAsSettings("io.purplejs"));
        return this;
    }
}

