/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.boot.internal.servlet;

import com.google.common.io.Resources;
import com.google.common.net.MediaType;
import io.purplejs.core.RunMode;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.MimeTypes;

public final class AssetFilter
implements Filter {
    private static final String ASSETS_ROOT = "/assets";
    private List<File> devSourceDirs;
    private MimeTypes mimeTypes = new MimeTypes();

    public void setDevSourceDirs(List<File> devSourceDirs) {
        this.devSourceDirs = devSourceDirs;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean served = this.serveResource((HttpServletRequest)request, (HttpServletResponse)response);
        if (!served) {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private boolean serveResource(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        URL url = this.findResource(request);
        if (url == null || url.getPath().endsWith("/")) {
            return false;
        }
        this.serveResource(response, url);
        return true;
    }

    private URL findResource(HttpServletRequest req) throws IOException {
        String path = req.getPathInfo();
        URL fromDev = this.findResourceInFolders(ASSETS_ROOT + path);
        return fromDev != null ? fromDev : this.getClass().getResource(ASSETS_ROOT + path);
    }

    private URL findResourceInFolders(String path) throws IOException {
        if (RunMode.get() != RunMode.DEV) {
            return null;
        }
        for (File folder : this.devSourceDirs) {
            File file = new File(folder, path);
            if (!file.exists()) continue;
            return file.toURI().toURL();
        }
        return null;
    }

    private void serveResource(HttpServletResponse res, URL url) throws IOException {
        String mimeType = this.findMimeType(url.getPath());
        res.setContentType(mimeType);
        byte[] bytes = Resources.toByteArray((URL)url);
        res.setContentLength(bytes.length);
        res.getOutputStream().write(bytes);
    }

    private String findMimeType(String path) {
        String mimeType = this.mimeTypes.getMimeByExtension(path);
        if (mimeType != null) {
            return mimeType;
        }
        return MediaType.OCTET_STREAM.withoutParameters().toString();
    }
}

