/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.boot.internal.server;

import io.purplejs.boot.internal.config.Configurable;
import io.purplejs.boot.internal.server.EngineConfigurator;
import io.purplejs.boot.internal.server.ServletConfigurator;
import io.purplejs.core.settings.Settings;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;

public final class ServerConfigurator
implements Configurable {
    private Server server;
    private HandlerCollection handlers;

    public Server getServer() {
        return this.server;
    }

    @Override
    public void configure(Settings settings) {
        EngineConfigurator engineConfigurator = new EngineConfigurator();
        engineConfigurator.configure(settings);
        ServletConfigurator servletConfigurator = new ServletConfigurator();
        servletConfigurator.setEngine(engineConfigurator.getEngine());
        servletConfigurator.setDevSourceDirs(engineConfigurator.getEngine().getDevSourceDirs());
        servletConfigurator.configure(settings);
        this.handlers = new HandlerCollection();
        this.handlers.addHandler((Handler)servletConfigurator.getHandler());
        this.configureServer(settings.getAsSettings("server"));
    }

    private void configureServer(Settings settings) {
        this.server = new Server(settings.get(Integer.class, "port").orElse(8080).intValue());
        this.server.setHandler((Handler)this.handlers);
    }
}

