/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.boot.internal.response;

import com.google.common.io.ByteSource;
import io.purplejs.http.Cookie;
import io.purplejs.http.Headers;
import io.purplejs.http.Response;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;

public final class ResponseSerializer {
    private final HttpServletResponse to;

    public ResponseSerializer(HttpServletResponse to) {
        this.to = to;
    }

    public void serialize(Response from) throws IOException {
        this.to.setStatus(from.getStatus().getCode());
        this.to.setContentType(from.getContentType().toString());
        this.serializeHeaders(from.getHeaders());
        this.serializeCookies(from.getCookies().values());
        this.getBody(from).copyTo((OutputStream)this.to.getOutputStream());
    }

    private ByteSource getBody(Response from) {
        ByteSource body = from.getBody();
        return body != null ? body : ByteSource.empty();
    }

    private void serializeHeaders(Headers headers) {
        headers.forEach((arg_0, arg_1) -> ((HttpServletResponse)this.to).addHeader(arg_0, arg_1));
    }

    private void serializeCookies(Iterable<Cookie> cookies) {
        cookies.forEach(this::serializeCookie);
    }

    private void serializeCookie(Cookie cookie) {
        this.to.addCookie(ResponseSerializer.translateCookie(cookie));
    }

    static javax.servlet.http.Cookie translateCookie(Cookie cookie) {
        javax.servlet.http.Cookie result = new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
        result.setPath(cookie.getPath());
        result.setComment(cookie.getComment());
        result.setMaxAge(cookie.getMaxAge());
        result.setHttpOnly(cookie.isHttpOnly());
        result.setSecure(cookie.isSecure());
        if (cookie.getDomain() != null) {
            result.setDomain(cookie.getDomain());
        }
        return result;
    }
}

