/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.boot.internal.servlet;

import io.purplejs.boot.internal.request.RequestImpl;
import io.purplejs.boot.internal.response.ResponseSerializer;
import io.purplejs.boot.internal.websocket.WebSocketHandler;
import io.purplejs.core.Engine;
import io.purplejs.core.resource.ResourcePath;
import io.purplejs.http.Request;
import io.purplejs.http.Response;
import io.purplejs.http.handler.HttpHandler;
import io.purplejs.http.handler.HttpHandlerFactory;
import io.purplejs.http.websocket.WebSocketConfig;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public final class ScriptServlet
extends HttpServlet {
    Engine engine;
    HttpHandler handler;
    private WebSocketServletFactory webSocketServletFactory;

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void init() throws ServletException {
        super.init();
        HttpHandlerFactory handlerFactory = (HttpHandlerFactory)this.engine.getInstance(HttpHandlerFactory.class);
        this.handler = handlerFactory.newHandler(ResourcePath.from((String)"/app/main.js"));
        this.initWebSocketFactory();
    }

    private void initWebSocketFactory() throws ServletException {
        try {
            this.webSocketServletFactory = new WebSocketServerFactory();
            this.webSocketServletFactory.getPolicy().setIdleTimeout(10000L);
            this.webSocketServletFactory.init(this.getServletContext());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        RequestImpl actualRequest = new RequestImpl(req);
        boolean isWebSocket = this.webSocketServletFactory.isUpgradeRequest(req, res);
        actualRequest.setWebSocket(isWebSocket);
        Response actualResponse = this.serve(actualRequest);
        if (actualResponse == null) {
            return;
        }
        if (!isWebSocket) {
            new ResponseSerializer(res).serialize(actualResponse);
            return;
        }
        WebSocketConfig config = actualResponse.getWebSocket();
        this.acceptWebSocket(req, res, config);
    }

    private Response serve(Request request) {
        try {
            Response response = this.handler.serve(request);
            return this.handler.errorIfNeeded(request, response);
        }
        catch (Exception e) {
            return this.handler.handleException(request, (Throwable)e);
        }
    }

    private void acceptWebSocket(HttpServletRequest req, HttpServletResponse res, WebSocketConfig config) throws IOException {
        WebSocketHandler creator = new WebSocketHandler(this.handler, config);
        this.webSocketServletFactory.acceptWebSocket((WebSocketCreator)creator, req, res);
    }

    public void destroy() {
        this.engine.dispose();
    }
}

