/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.boot.internal.request;

import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import io.purplejs.boot.internal.request.MultipartFormImpl;
import io.purplejs.core.exception.ExceptionHelper;
import io.purplejs.http.Headers;
import io.purplejs.http.MultipartForm;
import io.purplejs.http.Parameters;
import io.purplejs.http.Request;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public final class RequestImpl
implements Request {
    private static final MediaType MULTIPART_FORM = MediaType.create((String)"multipart", (String)"form-data");
    private final HttpServletRequest wrapped;
    private final Headers headers;
    private final Parameters parameters;
    private final ByteSource body;
    private final MultipartForm multipart;
    private final MediaType contentType;
    private final long contentLength;
    private boolean webSocket = false;

    public RequestImpl(HttpServletRequest wrapped) {
        this.wrapped = wrapped;
        this.contentLength = this.wrapped.getContentLength();
        String value = this.wrapped.getContentType();
        this.contentType = value != null ? MediaType.parse((String)value).withoutParameters() : null;
        this.body = this.readBody();
        this.parameters = RequestImpl.createParameters(this.wrapped);
        this.headers = RequestImpl.createHeaders(this.wrapped);
        this.multipart = this.readMultipart();
    }

    private boolean isMultipartForm() {
        return this.contentType != null && this.contentType.is(MULTIPART_FORM);
    }

    private ByteSource readBody() {
        if (this.isMultipartForm()) {
            return ByteSource.empty();
        }
        return RequestImpl.readBody(this.wrapped);
    }

    private MultipartForm readMultipart() {
        if (!this.isMultipartForm()) {
            return null;
        }
        return RequestImpl.newMultipartForm(this.wrapped);
    }

    public String getMethod() {
        return this.wrapped.getMethod();
    }

    public URI getUri() {
        return URI.create(this.wrapped.getRequestURL().toString());
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public ByteSource getBody() {
        return this.body;
    }

    public MultipartForm getMultipart() {
        return this.multipart;
    }

    public Object getRaw() {
        return this.wrapped;
    }

    private static Headers createHeaders(HttpServletRequest req) {
        Headers headers = new Headers();
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            headers.put((Object)key, (Object)req.getHeader(key));
        }
        return headers;
    }

    private static Parameters createParameters(HttpServletRequest req) {
        Parameters params = new Parameters();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            for (String value : req.getParameterValues(key)) {
                params.put((Object)key, (Object)value);
            }
        }
        return params;
    }

    static MultipartForm newMultipartForm(HttpServletRequest req) {
        try {
            return new MultipartFormImpl(req.getParts());
        }
        catch (Exception e) {
            throw ExceptionHelper.unchecked((Throwable)e);
        }
    }

    static ByteSource readBody(HttpServletRequest req) {
        try {
            byte[] data = ByteStreams.toByteArray((InputStream)req.getInputStream());
            return ByteSource.wrap((byte[])data);
        }
        catch (Exception e) {
            throw ExceptionHelper.unchecked((Throwable)e);
        }
    }

    public boolean isWebSocket() {
        return this.webSocket;
    }

    public void setWebSocket(boolean webSocket) {
        this.webSocket = webSocket;
    }
}

