/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.boot.internal.request;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.purplejs.boot.internal.request.MultipartItemImpl;
import io.purplejs.http.MultipartForm;
import io.purplejs.http.MultipartItem;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import javax.servlet.http.Part;

final class MultipartFormImpl
implements MultipartForm {
    private final Multimap<String, MultipartItem> map = HashMultimap.create();

    MultipartFormImpl(Iterable<Part> parts) {
        for (Part part : parts) {
            MultipartItemImpl item = new MultipartItemImpl(part);
            this.map.put((Object)item.getName(), (Object)item);
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int getSize() {
        return this.map.size();
    }

    public Optional<MultipartItem> get(String name) {
        Collection items = this.map.get((Object)name);
        return items.isEmpty() ? Optional.empty() : Optional.of(items.iterator().next());
    }

    public void delete() {
        this.map.values().forEach(this::delete);
    }

    public Iterator<MultipartItem> iterator() {
        return this.map.values().iterator();
    }

    private void delete(MultipartItem item) {
        ((MultipartItemImpl)item).delete();
    }
}

