/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tika.io.IOUtils;

public class StreamUtils {
    private StreamUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toString(InputStream inputStream, String encoding) {
        try (InputStream stream = inputStream;){
            String string = IOUtils.toString((InputStream)stream, (String)encoding);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert to string", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toByteArray(InputStream inputStream) {
        try (InputStream stream = inputStream;){
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert to byte array", e);
        }
    }

    public static void saveToFile(InputStream inputStream, File file) {
        try (InputStream stream = inputStream;
             FileOutputStream outputStream = new FileOutputStream(file);){
            IOUtils.copy((InputStream)stream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save to file", e);
        }
    }
}

